define([
    'underscore',
    'backbone',
    'moment',
], function(_, Backbone, moment) {
    'use strict';

    var EXPRESS_TEMPLATE = 'Express Care request at this location must be submitted before <%- end %> <%- timezone %>.';
    var expressMessageTemplate = _.template(EXPRESS_TEMPLATE);


    return Backbone.Model.extend({
        getExpressMessage: function() {
            return expressMessageTemplate(this.toJSON());
        },

        /**
         * Checks if the facility is currently open.
         * This function takes into account the timezone the facility is in.
         * @return {boolean}
         */
        isExpressAvailable: function() {
            var now = moment();
            // TODO: I think there is probably a chance for bug here if the local time is a different day than the
            // facility time (i.e. local time is after midnight and facility time is before, or vice versa).
            var start = this._offsetTime(this.get('start'));
            var end = this._offsetTime(this.get('end'));
            return this._between(now, start, end);
        },

        /**
         * Checks if now is between start and end
         * @param {moment} now
         * @param {moment} start
         * @param {moment} end
         * @return {boolean}
         * @private
         */
        _between: function(now, start, end) {
            var isAfterStart = now.isAfter(start);
            var isBeforeEnd = now.isBefore(end);
            return isAfterStart && isBeforeEnd;
        },

        /**
         * Creates a new moment object for today at the given hour and minute, with the appropriate UTC offset
         * @param {String} time Hour and minute in "HH:mm" format
         * @return {moment}
         * @private
         */
        _offsetTime: function(time) {
            var offsetTime = moment(time, 'HH:mm').zone(this.get('offsetUtc'), true);
            return offsetTime;
        },
    });
});
